/*
 * Decompiled with CFR 0.152.
 */
package org.example.redislimater;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.example.redislimater.ApiCall;
import org.example.redislimater.RedisUtils;
import org.example.redislimater.StringUtils;
import org.example.redislimater.exception.ApiCallException;
import org.example.redislimater.exception.BusinessException;
import org.example.redislimater.utils.IpUtils;
import org.example.redislimater.utils.Recode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ApiCallAdvice {
    private static final Logger interfaceLog = LoggerFactory.getLogger((String)"interfaceLog");
    @Resource
    private RedisUtils redisUtils;
    private static final String FORMAT_PATTERN_DAY = "yyyy-MM-dd";
    private static final String FORMAT_PATTERN_MILLS = "yyyy-MM-dd HH:mm:ss:SSS";

    @Pointcut(value="@annotation(org.example.redislimater.ApiCall)")
    public void apiCall() {
    }

    @Around(value="apiCall())")
    public Object requestLimitAround(ProceedingJoinPoint pjp) {
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        ApiCall apiCall = methodSignature.getMethod().getAnnotation(ApiCall.class);
        long limitCount = apiCall.limitCount();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String requestIp = IpUtils.getIpAddr(request);
        if (StringUtils.isEmpty(requestIp)) {
            interfaceLog.error("execute api {} error, ip is empty", (Object)methodSignature.getMethod().getName());
            throw new ApiCallException(Recode.IP_ERROR.getCode(), Recode.IP_ERROR.getDesc());
        }
        String uri = request.getRequestURI();
        String key = "API_LIMIT:" + uri + "_" + requestIp + "_";
        int size = this.redisUtils.keys(key + "*").size();
        if ((long)size > limitCount) {
            interfaceLog.error("execute api {} error, ip exceed max call limit!, IP is {}", (Object)methodSignature.getMethod().getName(), (Object)requestIp);
            throw new ApiCallException(Recode.LIMIT_ERROR.getCode(), Recode.LIMIT_ERROR.getDesc());
        }
        this.redisUtils.set(key + System.currentTimeMillis(), "1", apiCall.time(), apiCall.timeUnit());
        Object[] args = pjp.getArgs();
        try {
            String param = args.length == 1 ? JSON.toJSONString((Object)args[0]) : Arrays.toString(pjp.getArgs());
            long beginTime = System.nanoTime();
            Object result = pjp.proceed(args);
            long endTime = System.nanoTime();
            String resultJson = JSON.toJSONString((Object)result);
            interfaceLog.info("execute api : {},param: {},result:{},cost\uff1a{}ms", new Object[]{methodSignature.getMethod().getName(), param, resultJson, (endTime - beginTime) / 1000000L});
            return result;
        }
        catch (Throwable throwable) {
            interfaceLog.error("execute api:{}error, cause by {}, ip is{}", new Object[]{methodSignature.getMethod().getName(), throwable.getMessage(), requestIp});
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    @Before(value="apiCall()")
    public void before() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String uri = request.getRequestURI();
        String date = this.dateFormat(FORMAT_PATTERN_DAY);
        String ip = IpUtils.getIpAddr(request);
        if (StringUtils.isEmpty(ip)) {
            interfaceLog.error("execute uri {} error, Unauthorized access\uff01ip cannot empty\uff01", (Object)uri);
            throw new ApiCallException(Recode.IP_ERROR.getCode(), Recode.IP_ERROR.getDesc());
        }
        String ipKey = "API_LIMIT_DAY:" + uri + "_" + ip + "_" + date;
        if (this.redisUtils.hasKey(ipKey)) {
            if (Integer.parseInt(this.redisUtils.get(ipKey).toString()) > 10000) {
                interfaceLog.error("execute uri {} error, exceed max call limit\uff01,IP is :{}", (Object)uri, (Object)ip);
                throw new ApiCallException(Recode.LIMIT_ERROR.getCode(), Recode.LIMIT_ERROR.getDesc());
            }
            this.redisUtils.incr(ipKey, 1L);
        } else {
            this.redisUtils.set(ipKey, 1, 1L, TimeUnit.DAYS);
        }
    }

    @AfterReturning(value="apiCall()")
    public void afterReturning() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String uri = request.getRequestURI();
        String date = this.dateFormat(FORMAT_PATTERN_DAY);
        if (this.redisUtils.hasKey(uri)) {
            this.redisUtils.boundHashOpsIncrement(uri, date, 1L);
        } else {
            this.redisUtils.boundHashOpsPut(uri, date, 1L);
        }
    }

    @AfterThrowing(value="apiCall()", throwing="ex")
    public void afterThrowing(Exception ex) {
        interfaceLog.error("execute api error, cause by {}", (Object)ex.getMessage());
    }

    private String dateFormat(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(new Date());
    }
}

